Review

# Understanding the Adoption of Innovations in Agriculture: A Review of Selected Conceptual Models

Oscar Montes de Oca Munguia $^ { 1 , 2 , * \oplus } \oplus$ , David J. Pannell 1 and Rick Llewellyn $^ { 1 , 3 } \textcircled { \mathbb { D } }$

Citation: Montes de Oca Munguia, O.; Pannell, D.J.; Llewellyn, R. Understanding the Adoption of Innovations in Agriculture: A Review of Selected Conceptual Models. Agronomy 2021, 11, 139. https:// doi.org/10.3390/agronomy11010139

Received: 12 November 2020   
Accepted: 25 December 2020   
Published: 13 January 2021

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

1 School of Agricultural and Environment, The University of Western Australia, Crawley, WA 6009, Australia; david.pannell@uwa.edu.au (D.J.P.); Rick.Llewellyn@csiro.au (R.L.)   
2 SCION Research, Wellington 6011, New Zealand   
3 CSIRO, Glen Osmond, SA 5064, Australia   
Correspondence: oscar.montes@scionresearch.com

Abstract: Models can provide a structured way to think about adoption and provide a method to investigate the impacts of different factors in the adoption process. With at least 70 years of research in the adoption of agricultural innovations, there has been a proliferation of adoption models, both conceptual and numerical. This diversity has resulted in a lack of convergence in the way adoption is defined, explained, and measured, causing agricultural extension and policy to rely on a body of literature that is often not able to offer clear recommendations on the variables or mechanisms that can be used to design interventions. We conducted a review of conceptual models to clarify the concepts and approaches used in the practice of modeling adoption in agriculture. We described general adoption conceptual models originating from sociology, psychology, economics, and marketing and reviewed examples of models specifically defined for the study of adoption in agriculture. We also broadly assessed the ability of conceptual models to support building numerical models. Our review covered a range of modeling approaches for diffusion and individual adoption, illustrating different perspectives used in the literature. We found that key elements that should be used in adoption models for agriculture include: a way to assess the performance of the proposed new technology (e.g., relative advantage, both economic and non-economic) in relation to the existing technology or practice in place, the process of learning about this advantage, the interaction between individual decision-making and external influences, and characteristics of potential adopters affecting their attitudes towards the technology. We also detected inconsistencies in how different elements are treated in different conceptual models, particularly behavioral elements such as attitudes, motivations, intentions, and external influences. In terms of modeling, the main implication of these inconsistencies is the difficulty to generate quantitative evidence to support these models since multiple interpretations make it difficult to achieve consistency in the definition of observable, measurable variables that can be used to quantify cause-effect relationships. Suggestions for further research in the field include: questioning whether the adoption of all technologies and practices can be represented by the same adoption or learning process, exploring the dynamics in the relationship between adopters and technology before and after adoption, and questioning the basic assumptions behind the process of individual decision-making models and the role of collective decision-making. Findings from this review can be considered by adoption researchers and modelers in their work to assist policy and extension efforts to improve the uptake of future beneficial agricultural innovations.

Keywords: adoption modeling; diffusion; agricultural innovation systems; farmer decision-making; drivers of adoption

# 1. Introduction

Models can provide a structured way to think about adoption and provide a method to investigate the impacts of different factors in the adoption process. Adoption models can: (a) illustrate how the system works and identify key driving forces, (b) quantitatively predict the outcomes from the system, and (c) methodically analyze the uncertainty surrounding drivers and their effects on outcomes [1].

There are two broad categories of adoption models: theoretical or conceptual models and numerical models. Conceptual models use flow diagrams or algebraic equations to identify adoption factors and explain their relationships and effects without necessarily seeking to quantify them. Numerical models are normally built based on conceptual models, with the aim of quantifying the variables and the magnitude of the relationships that are represented in the conceptual models. Numerical models can therefore be used to validate a conceptual model, summarizing and embodying scientific knowledge.

With at least 70 years of research in the adoption of agricultural innovations, there has been a proliferation of adoption and diffusion models, both conceptual and numerical. Recent reviews like [2–4] illustrate this. Each model has been built to answer different questions, analyzing adoption in specific settings or at different scales, using different assumptions, data, and methods. Since no model can fully capture the adoption process, the variety of available models can be seen as a strength rather than a weakness.

Given the variety of purposes and assumptions of different models, cross-model comparisons are often not possible. Some authors suggest that it is not possible to find common patterns in agricultural innovation systems and that interventions cannot be expected to create predictable impacts [5]. Furthermore, meta-analyses and reviews conducted in adoption in agriculture often highlight the differences rather than the commonality among existing studies [3,6,7].

This observed diversity has resulted in a lack of convergence in the way adoption is defined, explained, and measured [8]. Montes de Oca Munguia and Llewellyn [1] (p. 80) point out that, “This absence of convergence matters for two reasons. Firstly, it means that there is a lack of clarity about the analytical methods and the choice of explanatory variables that we should use to model adoption. Secondly, it means that agricultural extension and policy are influenced by a body of literature that is often not able to offer a clear and consistent recommendation on the variables or mechanisms that can be used to design policy interventions”. In this review, we investigate possible reasons for this divergence.

Scholars argue that there is a need for meaningful synthesis and integration in the field of agricultural adoption to make it more practical for applied agricultural research, extension, and policy [8] (e.g., modeling). The objective of this review was to address this need by clarifying concepts and approaches used in the practice of modeling adoption in agriculture. The intended audience for this study was adoption researchers and modelers assisting policy and extension efforts to improve the uptake of future beneficial agricultural innovations.

The first section of this review describes early studies from sociology, psychology, economics, and marketing and draws upon more recent highly influential integrative studies that have developed models specifically for the study of adoption in agriculture. The difference between diffusion and adoption models are explained, and two modeling approaches that have influenced the research field are described.

Secondly, we reviewed a sample of conceptual models used as the basis to build the numerous numerical models in the adoption literature. Figure 1 shows the models or studies that we have chosen as examples. The selection of these examples was based on their ability to illustrate the different disciplinary perspectives used to explain adoption and their ability to illustrate the wide range of variables that have been used in subsequent empirical studies; in this study, they were broadly classified into two dimensions according to the nature of their concepts: those more focused on the characteristics of the adopter and those more focused on the characteristics of the technology, and whether the models were more focused on understanding the individual process of decision-making, or incorporated external influences into the adoption decision (i.e., extended behavioral models).

![](images/9d334043264a4801a4a111bf7ff8f96ec30ff753a8bd22b880f05d67cea4f26f.jpg)  
Figure 1. Conceptual models selected to illustrate a range of modeling approaches for adoption [9–18]Figure 1. Conceptual models selected to illustrate a range of modeling approaches for adoption [9–18].

In our review, we analyzed the suitability of these conceptual models to generateIn our review, we analyzed the suitability of these conceptual models to generate quantitative supporting evidence (e.g., their ability to identify observable, measurablequantitative supporting evidence (e.g., their ability to identify observable, measurable variables that can be used to quantify cause-effect relationships) only in broad terms. Wevariables that can be used to quantify cause-effect relationships) only in broad terms. also note cases where these models have been adapted specifically for adoption in agri-We also note cases where these models have been adapted specifically for adoption in culture, citing recent studies as examples. agriculture, citing recent studies as examples.

# 2. Early Studies2. Early Studies

The initial call for a mathematical formulation to explain the diffusion of agriculturalThe initial call for a mathematical formulation to explain the diffusion of agricultural innovation (hybrid seed corn) was made by the sociologists Ryan and Gross [19]. Fourinnovation (hybrid seed corn) was made by the sociologists Ryan and Gross [19]. Four important subsequent studies set the basis for the theories, models, and analytical meth-important subsequent studies set the basis for the theories, models, and analytical methods ods that still heavily influence the literature in adoption studies: Griliches [20], Rogersthat still heavily influence the literature in adoption studies: Griliches [20], Rogers [21], [21], Bass [22], and later Ajzen [11]. These were based on four individual disciplines: eco-Bass [22], and later Ajzen [11]. These were based on four individual disciplines: economics, sociology, marketing, and psychology, with sometimes fundamentally differentnomics, sociology, marketing, and psychology, with sometimes fundamentally different assumptions regarding the processes that drive adoption.assumptions regarding the processes that drive adoption.

Griliches established the use of regression modeling to provide evidence of adoption in agriculture. He studied the adoption of hybrid corn in US regions based primarily on yield and profit advantage. At about the same time, Rogers defined the diffusion of innovations (DOI) theory as the process by which innovations are communicated over time among the members of a social system and identified attributes of innovations that influence adoption: relative advantage, compatibility, complexity, trialability, and observability. Rogers used sociological theory to propose that the perception of these attributes by each potential adopter is the main influence on adoption decisions. Bass-based marketing numerical models are considered the most statistically robust models to predict market penetration (first purchase)—the rate of adoption and speed of adoption [9]. Finally, the psychologybased Theory of Planned Behaviour (TBP) [11] has been widely used to understand the individual adopter’s internal process of decision-making and how this process is also affected by external influences such as social norms and perceived control influences.

The differences in how adoption has been perceived by individual disciplines are well documented in the literature. For example, in their study of the nature of innovation diffusion in the agricultural sector, Sneddon et al. [23] concluded that “ . . . an evolutionary social process underlies agricultural innovation and that further research needs to be undertaken to examine such innovations from this perspective” (p. 478). They highlighted “ . . . the inadequacies of assuming economic rationality or efficient choice in the decision to adopt or reject new agricultural technologies” (p. 478). Sneddon et al. [23] conducted their study from the perspective of marketing. In this study, we considered that their findings exemplify the differences in approach and tension that exist between disciplines. Young [24], an economist, analyzed the mathematical properties of benchmark diffusion models from the three disciplines to compare the adoption curves generated by them. He offered a synthesis of the origins and evolution of diffusion models, including their fundamental differences in assumptions (Table 1).

Table 1. Comparison of three classes of models of innovation adoption. Based on Young [24].   

<html><body><table><tr><td>Discipline</td><td>CMsdef</td><td>Brief Description</td><td> Summary of Assumptions</td></tr><tr><td>Marketing</td><td>Contagion and</td><td>w</td><td></td></tr><tr><td>Sociology</td><td>Social influence</td><td> People adpt woup haoughoter people in</td><td>coforialyoireinatirsncehange</td></tr><tr><td></td><td>EconomicsSocial learning</td><td>People adopt once they see enough empirical evidence to convince them that the among prior adopters and other relevant information sources.</td><td></td></tr></table></body></html>

In order to compare the performance of models representing the three disciplines, Young used the diffusion data of hybrid corn from the classic study of innovation diffusion [19]. Interestingly, he concluded: “ . . . we can say that the social learning is consistent with the observed pattern of diffusion of hybrid corn, although we cannot say that it was the sole explanatory factor. We can say with some confidence, however, that inertia and contagion were probably not the sole explanatory factors . . . and neither was social influence” (p. 1919). Both the Sneddon et al. and Young [23,24] studies seem to agree on the need for a multidisciplinary understanding of adoption.

# 3. Adoption, Diffusion, and Modelling Approaches

In this study, the distinction made between adoption and diffusion in terms of mathematical modeling is of scale and modeling perspective: while the adoption perspective uses the individual as the unit of analysis, the diffusion perspective considers the population of adopters as a whole. Rogers’ DOI theory [21] describes patterns of adoption amongst entire populations. His approach, therefore, uses a generalization of the social system (versus individual) as the unit of analysis [25]. This is a simple but important distinction because numerical adoption models might consider the drivers that influence decision-making at the individual level (e.g., using TPB) and then aggregate up, while numerical diffusion models could consider the same drivers but making assumptions about their collective effects on a population (e.g., using the Bass model).

The aggregate effects of adoption can be observed at the diffusion level. In this study, we consider four diffusion outcomes relevant to agriculture:

• Peak adoption: the cumulative number of new adopters of new technology or practice amongst a target population of potential adopters.   
• Adoption speed: the time (usually measured in years) to reach peak adoption. Duration of use: the time (usually measured in years) that practice or innovation is in use within the target population before it is replaced, or its use ceases for other reasons. Extent of use: the degree of intensity of the implementation of the technology or practice. This outcome is different from the first three because it is not measured in terms of a population of potential adopters but in terms of other variables, such as land area [8].

Besides the unit of analysis, we highlight another important difference between numerical models: the degree to which decision-making is modeled as a sequential process. Most current models in the agricultural adoption literature consider adoption as a binary, ‘once-off’ decision [8]. This approach is like the marketing concept of ‘first purchase’, on which most diffusion models are based. We next describe a Bass-like diffusion model (based on Parker [9]) to illustrate this modeling approach. On the other hand, some models do choose to model adoption as a staged process. A step-hazard adoption model (based on Dekimpe et al. [26]) is used to illustrate this approach.

# 3.1. Bass-Like Modelling Approach

The Bass model, continuously modified and extended, consists of two parameters to generate a diffusion curve: $^ { a , }$ or the “coefficient of innovation, external influence or advertising effect” and $b ,$ or the “coefficient of imitation, internal influence or word-ofmouth effect”, as seen in Equation (1).

$$
n \bigl ( t \bigr ) = \bigl [ a + b \bigl ( N \bigl ( t \bigr ) / M \bigr ] \bigl [ M - N \bigl ( t \bigr ) \bigr ]
$$

where $a$ and $b$ are positive constants, $n ( t )$ are the number of adopters in time t, $N ( t )$ are the cumulative number of adopters up to but not including $t ,$ and $M$ is the market potential (i.e., the population of potential adopters). $a$ defines the intercept; the number of adoptions in the initial year of technology introduction. It sets the start of the curve, and $b$ defines both the timing and amplitude of the peak. It is the ‘contagion effect’ or cumulative learning.

Parker [9] conducted a review of diffusion models used for forecasting and concluded that an extended Bass-type model is the most mathematically robust and flexible function to model sigmoidal curves. He extended the Bass model to increase statistical robustness and increase the ability to adjust the shape of the sigmoidal curve (e.g., timing, amplitude, and skewness). Parker’s model is presented in Equation (2).

$$
n ( t ) = [ a + b [ N ( t ) / c M ( t ) ] ^ { ( 1 + d ) } ] [ c M ( t ) - N ( t ) ]
$$

where, similarly to $( 1 ) , a , b , c ,$ and $d$ are estimated constants, $n ( t )$ are the number of adopters in time $t , N ( t )$ is the cumulative number of adopters up to but not including $t ,$ and $M ( t )$ is the market potential at time t. The model added the variables $c$ and $d . \ c$ is the “long-run penetration ceiling among the population” and defines the ultimate adoption level by the population, while $d$ , or “Non-uniform interpersonal influences” (NUI), defines the (skewness), affecting the speed of diffusion. It counteracts $b$ to reflect changes in adopters’ immunity to contagion effect as the technology matures.

The Bass and Parker models illustrate the use of a highly simplified model with aggregated parameters to represent decision-making: the coefficients of innovation, imitation, and NUI. Because of this level of aggregation, diffusion models often lack the ability to identify nuanced cause-effect relationships between parameters affecting individual adoption. The effect of specific actions could potentially be estimated using these aggregated parameters (e.g., the effects of awareness or marketing campaign or a policy intervention in the population), but it is likely that these estimations would potentially over-simplify the complexity of adoption in agriculture.

# 3.2. Staged Adoption Modelling Approach

Most adoption conceptual models in agriculture define adoption as an informationdriven staged process [10,21,27]. Since Rogers [21] defined adoption as “the mental process an individual passes from first hearing about an innovation to final adoption (of the technology)”, it is commonly accepted that an innovation’s final adoption is only reached after going through a process of learning and experimentation. Rogers’ Information-Decision Process Model [28] proposed a five-staged model: knowledge, persuasion, decision, implementation, and confirmation. Adrian [29] identified and used an earlier model to analyze the adoption of precision agriculture: the Transtheoretical Model [27]. This model also consists of five stages to explain how an individual considers a change, prepares for change, makes the change, and maintains the changed behavior. The stages are pre-contemplation, contemplation, preparation, action, and maintenance. Pannell et al. [30] outlined a staged process of adoption at a farm level consisting of the following stages: awareness, non-trial evaluation, trial evaluation, adoption, review and modification, and dis-adoption.

All of these conceptual models explain, in different ways, “the process people go through when becoming aware of the possibility of a change, the decision to adopt, the implementation of the change, and the maintenance of the change” [29] (p. 14). Conceptualizing adoption as a staged process is potentially more useful to design interventions than an aggregated approach because it could help target parameters affecting specific adoption stages (e.g., where extension efforts would be more effective, where the policy would influence the most). In process models, transitions between stages are driven by information—the decision-maker transitions from one stage to the next depending on the accumulation of information and the speed to process it [10].

Some authors use a step-hazard approach to represent the different stages of the adoption process as a way to better understand the transitions between them [31]. The duration equations to move from one state to the next are assumed to be determined by different processes. The step-hazard approach has been successfully used to represent Rogers’ adoption process in several studies [32], and there are some examples in the marketing literature using a step-hazard approach at a national or international level [26,32,33]. However, there are very few similar studies in agriculture (e.g., [34,35]). Figure 2 shows how the adoptionREVIEW 7 of 21 process proposed by Pannell et al. [30] can be represented as a step-hazard model.

![](images/27a973415b39d0a3d20055ad94395c25c7c3f1175d362ca2e3cfc3771db87199.jpg)  
Figure 2. Step-hazard representation of the adoption process proposed by Pannell et al. [30]. Figure 2. Step-hazard representation of the adoption process proposed by Pannell et al. [30].

In Figure 2 the boxes represent the different adoption states and ${ \bf r } _ { \mathrm { i } }$ the transition rates between states. Implicit in this process is the possibility that farmers may fail to proceed to a subsequent stage, stopping at one of the boxes, or even stopping prior to reaching the Awareness box. Conceptually, it could be possible to establish and test the links between each transition rate with specific adoption outcomes.

# 4. Conceptual Models of Adoption

As seen in Figure 1, we have classified conceptual models in two dimensions according to the nature of their elements: those more focused on the characteristics of the adopter and those more focused on the characteristic of the technology, and whether the models were more focused on understanding the individual process of decision-making, or incorporated external influences into the adoption decision (i.e., extended behavioral models). Their placement in the grid is indicative only, as many models could also contain elements from other quadrants.

The ADOPT model [14] integrates elements of all quadrants. To illustrate individual decision-making process models mainly focused on the adopter, we selected Bass-like models [9], described in the previous section, and an information flow model (based on Lindner et al. [10]. We selected a dynamic, risk-economic conceptual model: Abadi Ghadim and Pannell [13] to illustrate individual decision-making process models with a focus on both adopters and technology, and a technology-task fitness model based on Goodhue and Thompson [17] and Venkatesh [18] to illustrate individual decision-making process models mainly focus on the technology. We selected three extended behavioral models of adoption in this review: a model incorporating the TPB: Zeweld et al. [12] to illustrate models mainly focused on external influences on the decision-makers, a technology acceptance model [17] as an extension of task-technology fitness, and a satisfaction model (based on Johnson et al. [15]).

# 4.1. The ADOPT Model

The ADOPT conceptual model of adoption and diffusion is shown in Figure 3. The model represents cause-effect relationships driving individual adoption and contributing to two diffusion outcomes (peak adoption and adoption speed) using the relationships between 22 variables. The cause-effect relationships shown in the conceptual model have been supported by economic and sociology literature in agriculture [14]. The main economic and sociological theoretical constructs in this model are Relative advantage and Learning of Relative Advantage.

# 4.1.1. Relative Advantage

The first high-level driver of adoption in the ADOPT model is a relative advantage. Theories related to relative advantage for modeling are well supported in the literature and include subjective expected utility theory [36], prospect theory [37], and multi-attribute utility theory [38]. The application of these theories in models of decision-making has been reviewed extensively (e.g., [39]). The use of different population orientations (i.e., preferences) to weight characteristics of the practice when calculating overall relative advantage in the conceptual model illustrates the interplay between rewards, effort, and risk in decision-making in agriculture, as proposed by Nicholson et al. [40].

A large body of research has shown that the main driver of voluntary adoption of innovations in agriculture is a relative advantage (Pannell and Vanclay 2011). The concept of relative advantage represented in the ADOPT conceptual model means “the degree to which an innovation is perceived as being better than the idea it supersedes” [28] (p. 229). This definition allows for the inclusion of multiple factors that affect farmers’ decisions [30]. In the ADOPT model, there are three decision maker’s orientations (profit, environmental, and risk) that can influence the relative advantage of the technology or practice under analysis on those three components.

![](images/243eb4a3a2143ef9daad952fbf3d35ec2f97015fbbad8895e5be53d123912932.jpg)  
Figure 3. The ADOPT conceptual model. Based on Kuehne et al. [14]. (Permission obtained).

# 4.1.2. Learning of Relative Advantage

The second high-level factor represented in the ADOPT model is learning. The ADOPT conceptual model identifies the variables and cause-effect relationships affecting the likelihood of adoption and the time elapsed from the availability of agricultural innovation to the decision to adopt it as suggested by Lindner et al. [10]: the discovery stage—the time it takes for the producer to be aware of the existence of the innovation, the evaluation stage—the time from awareness to first use, on a trial basis, and the trial stage—the time from the initiation of trial use to the acceptance of the innovation. Characteristics of the innovation interact with characteristics of the population of adopters to affect the time to adopt an innovation, thus covering the stages of awareness, trialing, and adoption outlined by Pannell et al. [30].

In ADOPT, the construct of learning affects the speed of adoption and is heavily influenced by the original work of Lindner et al. [10], but unlike Lindner et al., it does not explicitly represent the information flows driving the transition between stages. Lindner et al. suggested that “the duration of the time lag in each stage will be directly related to the minimum amount of required information, and inversely related to the rate at which is collected” (p. 100).

All the conceptual models and theories of adoption analyzed in this study are well established in the literature; some of them have been applied fully or partially in agriculture, and some have not. However, so far, only the ADOPT conceptual model has been purposely defined to build a predictive numerical model in agriculture.

# 4.2. Information Flows Model

Lindner et al. [10] outlined the basic process driving the time lag from the availability of agricultural innovation to the individual decision to adopt it: the discovery stage—the time it takes for the producer to be aware of the existence of the innovation, the evaluation stage—the time from awareness to first use, on a trial basis, and the trial stage—the time from the initiation of trial use to the acceptance of the innovation.

Lindner et al. suggested that information plays a central role in the three stages, noting differences in the nature of the information collected. They suggested that during the discovery stage, the producer is actively seeking information about the existence of previously unknown innovations, while the second and third stages consist of collecting innovation-specific information about its attributes to make the decision to first trial it and then adopt it. During the evaluation stage, this information is sourced from off-farm sources, while the information collected in the trial period originates mainly on-farm.

Lindner et al. also suggested that the transition from one stage to the next depends on the accumulation of information and the speed to process it. The discovery stage will terminate when the producer has canvassed sufficient information sources to become aware of the innovation. The evaluation stage terminates when the producer has accumulated sufficient information from off-farm sources to be convinced to trial the innovation or not trial it.

The minimum quantity of information required to move from any stage will depend on the producer’s perception of the quality or reliability of the information. Quality, in this case, is measured by the level of uncertainty about the relevance of the information for their agribusiness. Lindner et al. also suggested that the minimum quantity of information to move from awareness to trial will depend on the producer’s pessimism and conservatism related to their initial belief about the innovation’s relative advantage and their level of innovativeness, or inherent propensity to adopt quickly, as proposed by Rogers [28].

The key message from Lindner et al. and subsequent studies [41,42] is that the chances of trialing and adoption are highest if the innovation is perceived as highly relevant to theEER REVIEW 10 of 21 potential adopter’s agribusiness [14,30], as shown in Figure 4.

![](images/8cfe1d0c6feedac34b1dc756322e54639fc919715f7f5fed00c2eef88d90efe3.jpg)  
Figure 4. Information flow conceptual model. Based on Lindner et al. [10]. Figure 4. Information flow conceptual model. Based on Lindner et al. [10].

sion to trial and adopt (before trial evaluation) and the role of information generated on-Figure 4 illustrates the role of off-farm information sources in influencing the decision farm leading to adoption. There is some research showing the links between information-to trial and adopt (before trial evaluation) and the role of information generated on-farm seeking behaviors and adoption in dairy farms [43]. leading to adoption. There is some research showing the links between information-seeking behaviors and adoption in dairy farms [43].

# Abadi Ghadim and Pannell [14.3. Dynamic, Risk-Economic Model

al. [10] ideas by conceptualizing the process of adoption as a dynamic process that spans Abadi Ghadim and Pannell [13] proposed a conceptual framework for individual several years. In their model, the adoption decision involves changes in the decision-adoption using economic and sociological theory. Their model implemented Lindner maker’s perceptions and attitudes as information is progressively collected. et al. [10] ideas by conceptualizing the process of adoption as a dynamic process that spans several years. In their model, the adoption decision involves changes in the decisionmodel represents the problem of adoption as a rational economic decision with the objemaker’s perceptions and attitudes as information is progressively collected.

tive of profit maximization or expected utility maximization. In their framework, the ex-Abadi Ghadim and Pannell’s model includes the role of farmer’s personal perceptions, pected profitability or expected utility of innovation is increased over time due to skill managerial abilities, and risk preferences over time in deciding to adopt. Their model repdevelopment, and the ability to make good decisions about the innovation is increased resents the problem of adoption as a rational economic decision with the objective of profit profitability of the innovation and the effects of trials and experimentation in reducing maximization or expected utility maximization. In their framework, the expected profthis uncertainty and combines this with the farmer’s risk preferences. itability or expected utility of innovation is increased over time due to skill development, Abadi Ghadim and Pannell’s [13] model considers that the decision to trial and adopt and the ability to make good decisions about the innovation is increased with experience.

The model includes the influence of uncertainty about the long-term profitability of the innovation and the effects of trials and experimentation in reducing this uncertainty and combines this with the farmer’s risk preferences.

Abadi Ghadim and Pannell’s [13] model considers that the decision to trial and adopt an innovation depends on the subjective perception of the performance of the innovation in relation to an alternative. This perception of expected profit is further combined with the farmer’s perception of risk and their attitude to risk to define adoption as the result of maximizing the expected utility of profit—which is a form of subjective expected utility theory [36]. This concept of relative advantage was expanded in the ADOPT conceptual model by also including an environmental orientation as well as profit and risk orientations.

Abadi Ghadim and Pannell’s model relies on a combination of objective variables (gross margins, farm area, costs, net profits, farmer’s planning horizon) and variables that are difficult to be measured objectively (attitude to risk, the value of information from trialing for skill development).

# 4.4. Task-Technology Fitness Model

The approach taken in the ADOPT model of matching population and innovation characteristics to calculate relative advantage resembles early task-technology fitness models [17,18,44], as shown in Figure 5.

![](images/5c2052752e44ade1a2d829a09e478e5d84d3df1b0fdcaa66b4d21b19bc1a733e.jpg)  
Figure 5. A representation of task-technology fitness theory. Based on Goodhue and Thompson.[17]. Figure 5. A representation of task-technology fitness theory. Based on Goodhue and Thompson [17].

In a task-technology fitness model, there is an emphasis on the role of technology as an intermediary between individual preferences and task characteristics. This model is a good reminder that in agriculture, it is highly likely that there is already a technology or practice in use fulfilling each task and thus delivering benefits to the landowner. Therefore, any new technology is very likely to be a replacement for the existing one. The concept of “task” can be interpreted as a discrete activity (e.g., harvesting), or it could also be extended to represent an activity within a farming circumstance (e.g., irrigation within a water allocation limit). Farming conditions are dynamic, requiring a constant revision of the performance of current technologies. A “new task” can, therefore, arise when farming conditions change (e.g., new environmental regulations are introduced), needing new technologies or practices to be considered. In many cases, however, under relative stability, new technologies or practices would likely result in only incremental improvements on the current technology’s performance (e.g., a new crop cultivar).

The task-technology fitness model is a good reminder of the need to understand better the current technology in order to make a more accurate measure of relative advantage [1]. In an individual decision-making process model, a new opportunity is open when there is a gap between the existing technology’s capabilities and the requirements brought in by changing farming conditions. This means that a landowner’s knowledge about innovation can remain in the “awareness” stage until it becomes sufficiently relevant.

Relevance can, therefore, be measured as the ability of new technology or practice to fill the performance gap.

The constructs in the technology-task fitness model are especially relevant to explain continuing use and use intensity because of the constant evaluation of the relative advantage between alternatives that could lead to identifying gaps in performance that could trigger a technology substitution process.

# 4.5. Theory of Planned Behaviour

Models based on rational choice are often criticized for not taking into account cognitive and social–psychological factors that can influence farmer’s attitudes and intention to adopt, including the role of other people’s opinions [45]. This section, therefore, reviews some models that apply social psychology theories to explain elements of adoption not included in individual decision-making process models.

The dominant psychological model of decision-making and behavior is the Theory ofEW 12 of 21 Planned Behaviour (TPB) [11]. TPB has been used as the basis for other behavioral models, like the theory of reasoned action (TORA) and technology acceptance models (covered later in this section). While the relative advantage is concerned with variables that can explain the fitness of the innovation to satisfy the producers’ preferences, the TPB is concerned withels, like the theory of reasoned action (TORA) and technology acceptance models (covered variables that affect the behavior of the potential adopter. TPB has been used to explain thelater in this section). While the relative advantage is concerned with variables that can relationship between values, attitudes, and behavioral intentions to predict behavior. Itsexplain the fitness of the innovation to satisfy the producers’ preferences, the TPB is concomponents include values, norms, attitudes, beliefs, perceptions of social pressure, andcerned with variables that affect the behavior of the potential adopter. TPB has been used beliefs about the level of control to make decisions.to explain the relationship between values, attitudes, an

The TPB has been combined with other relevant theories such as the self-identitybehavior. Its components include values, norms, attitudes, beliefs, perceptions of social theory and the cultural identity theory [46] to better explain farmers’ decision-making. The principles of TPB have been used in agriculture to define farmers’ segments or typologiesory and the cultural identity theory [46] to better explain farmers’ decision-making. The based on attitudes to predict behavior [47,48] and to analyze farmers’ attitudes towardsprinciples of TPB have been used in agriculture to define farmers’ segments or typologies adopting environmental practice [49–52]. However, the majority of adoption studiesbased on attitudes to predict behavior [47,48] and to analyze farmers’ attitudes towards in agriculture include measures of attitudes without adhering to one particular theoryadopting environmental practice [49–52]. However, the majority of adoption studies in (e.g., [53–55]).agriculture

In the TPB, attitudes are assumed to be causally related to rational behavior when the decision-makers have control over decisions. However, this rational process is affected bydecision-makers have control over decisions. However, this rational process is affected by both subjective norms and perceived control. Figure 6 shows the TPB model characterizingboth subjective norms and perceived control. Figure 6 shows the TPB model characterizing the influences in the decision-making process as proposed by Ajzen [11], and Figure 7the influences in the decision-making process as proposed by Ajzen [11], and Figure 7 shows shows a recent example of the TPB applied in agriculture.a recent example of the TPB applied in agriculture.

![](images/1039f0fe0a46b46f40e03d4ca52dfa458d0e3074b782c96fb0ee9005a9800aa3.jpg)  
Figure 6. A representation of the Theory of Planned Behaviour. Based on Ajzen [11]. Figure 6. A representation of the Theory of Planned Behaviour. Based on Ajzen [11].

![](images/1418e7614885516b8e126d0133c4613f3d5de88d9eeaadb462fc655140afd5f7.jpg)  
Figure 7. Conceptual framework for behavioral intention towards sustainable agricultural practices. Based on Zeweld et al. [12]. Figure 7. Conceptual framework for behavioral intention towards sustainable agricultural practices. Based on Zeweld et al. [12]. (Permission obtained).

odel. Figure 7 shows how variables listed in the top left box measure relative advantage, Figure 6 shows how attitudes are affected by a rational process of evaluating the outcomes of different options. Subjective norm (the perceived social pressure to behave a certain way) is affected by normative beliefs (perceived pressure from influential people on the decision to adopt. or groups) and the decision-maker’s motivation to comply with their wishes. Perceived control is affected by specific control beliefs (the perception of the degree to which various 4.6. Technology Acceptance Models environmental factors make it easy or difficult to perform a behavior) and the perceived Task-technology fitness models have now invariably been combined with either TPB level of personal power to facilitate or inhibit them (e.g., self-efficacy—the decision-maker’s or TORA behavioral theories, resulting in Technology Acceptance Models (TAM), in belief in his/her effectiveness in performing specific tasks as well as by their actual skill).

hich the fitness of technology to perform a task is only a precursor of adoption and uti-We found some similarities between this model and the concepts in the ADOPT model. lization. In technology acceptance models, the perceived fitness of the technology informs Figure 7 shows how variables listed in the top left box measure relative advantage, affecting the “intention to adopt”, which not always translates into adoption. Therefore, psycho-attitudes, while the second set of variables, in the middle left box, relate to learning of logical and sociological theories of attitudes and behaviors are important elements of tech-relative advantage. The third set of variables, in the bottom left box, are mostly covered nology acceptance models, as shown in Figure 8. in ADOPT, except for external influence—or how important are other’s opinions on the decision to adopt.

# 4.6. Technology Acceptance Models

Task-technology fitness models have now invariably been combined with either TPB or TORA behavioral theories, resulting in Technology Acceptance Models (TAM), in which the fitness of technology to perform a task is only a precursor of adoption and utilization. In technology acceptance models, the perceived fitness of the technology informs the “intention to adopt”, which not always translates into adoption. Therefore, psychological and sociological theories of attitudes and behaviors are important elements of technology acceptance models, as shown in Figure 8.

![](images/3436620d7b0152822fb397d05dd488e2e2853b71c192b83521b1d03370246972.jpg)  
Figure 8.Figure 8. The Technology-to-performance Chain. Based on Goodhue and Thompson [The Technology-to-performance Chain. Based on Goodhue and Thompson [17].  17].

In agriculture, there are some studies using behavioral theory and TAM to measure relative advantage (e.g., [56–58]) and some point out considerable discrepancies between intention to adopt and actual adoption (for example, [52]).

There are some studies proposing reasons for ‘latency’ in adopting seemingly advantageous innovations. Barr [43] suggests that the adoption decision process, especially of those innovations that carry significant risks to the landowner (e.g., dairy conversion), is an expensive process: stressful, long, and extensive. He also mentions the role of two particular heuristics to be taken into account in the adoption decision under high uncertainty or risk: the recognition heuristic (i.e., doing what is familiar) and the imitation heuristic (i.e., copying others) [36].

Recent work in cognitive psychology suggests that imitative behavior increases when uncertainty increases, while individual decision making prevails in conditions of low uncertainty [59]. In terms of modeling, this could be an important principle to test in agriculture. Unfortunately, there seem to be no studies in agriculture testing these concepts.

# 4.7. Satisfaction Models

In contrast to the processes driving the initial uptake of agricultural innovations, the processes driving their ongoing use have not been researched widely. The marketing literature has developed a large body of research on understanding the behavioral processes that determine the sustained use of innovations and the intensity of their use. Customer satisfaction indices were introduced in the 1990s at a national and international level to better understand consumer loyalty, resulting in a variety of psychology-based models (Johnson et al. [15]). Recent research efforts have been driven by the Information and Communication Technology (ICT) sector. For that industry, as for agriculture, sustained use and use intensity are substantially more important than first purchase [60]. These models propose that understanding the use of innovations requires research that moves away from transactional to relational viewpoints [15]. Central to these models is the concept of satisfaction and loyalty as “attitude-type evaluations” [15,61]. A positive experience using the innovation causes satisfaction, which in turn causes the user’s loyalty towardsfrom transactional to relational viewpoints [15]. Central to these models is the concept of the innovation. The concept of satisfaction is synonymous with the concept of consumptionsatisfaction and loyalty as “attitude-type evaluations” [15,61]. A positive experience using utility in economic psychology and welfare economics [15].the innovation causes satisfaction, which in turn causes the us

Even when the relationships between quality of experience, satisfaction, and loyaltyovation. The concept of satisfaction is synonymous with the concept of consumption are circular (i.e., reinforcing), models of satisfaction have been able to represent the process successfully as a linear progression by defining satisfaction and loyalty as cumulativeare circular (i.e., reinforcing), models of satisfaction have been able to represent the probehavioral intentions [62]. Research on satisfaction models also suggests a clear separationcess successfully as a linear progression by defining satisfaction and loyalty as cumulative between behaviors when assessing the performance of innovation before and after firstbehavioral intentions [62]. Research on satisfaction models also suggests a clear separation purchase, to the point that some authors propose that the pre-first purchase expectationsbetween behaviors when assessing the performance of innovation before and after first on innovation performance play virtually no role in the perceived quality and value of thepurchase, to the point that some authors propose that the pre-first purchase expectations innovation once it is purchased [15].on innovation performance play virtu

Satisfaction models, therefore, open the possibility of explaining the ongoing use andnovation once it is purchased [15]. intensity of use of agricultural innovations. A high level of satisfaction with the innovationSatisfaction models, therefore, open the possibility of explaining the ongoing use and could lead to continuing use and intense use. A high level of satisfaction could also lead tointensity of use of agricultural innovations. A high level of satisfaction with the innovation increased loyalty to the innovation and the institutions behind it. A reduction in the level of satisfaction could, in turn, trigger the need to discover a new alternative. Figure 9 shows a satisfaction model based on Johnson et al. [15].

![](images/6b79fd917cc902cc11b56eb141421716f9331f18b0f609292dc0e93dd4272d8a.jpg)  
Figure 9. Satisfaction model to explain the use of innovations. Based on Johnson et al. [15]. Figure 9. Satisfaction model to explain the use of innovations. Based on Johnson et al. [15].

Two measures used to quantify the quality of experience are based on early work by Two measures used to quantify the quality of experience are based on early work by Deming [63] and Juran and Gryna [64]. The measures are customization, or the degree to Deming [63] and Juran and Gryna [64]. The measures are customization, or the degree to which technology or practice provides key customer requirements, and reliability, or how which technology or practice provides key customer requirements, and reliability, or how consistently these requirements are delivered. A third measure, quality of experience, is consistently these requirements are delivered. A third measure, quality of experience, is perceived value or a rating of the quality received for the price paid [61]. Customization, or practice, determining the degree and speed of replacement of the existing technology reliability, and perceived value are continuous evaluations against the existing technology or practice. Some studies explore the quality of experience criteria to evaluate the perfor-or practice, determining the degree and speed of replacement of the existing technology or mance of agricultural technologies (e.g., [56,58]). practice. Some studies explore the quality of experience criteria to evaluate the performance Loyalty is the definitive dependent vaof agricultural technologies (e.g., [56,58]).

ehavioral intention that best predicts customer retention [15]. Customer loyalty is the Loyalty is the definitive dependent variable in models of satisfaction because it is the customer’s psychological predisposition to keep using a product or service [65]. behavioral intention that best predicts customer retention [15]. Customer loyalty is the Because satisfaction models are relational rather than transactional, loyalty captucustomer’s psychological predisposition to keep using a product or service [65].

ot only the relationship between the user and the technologies or practices but also be-Because satisfaction models are relational rather than transactional, loyalty captures not only the relationship between the user and the technologies or practices but also between the users and the companies or institutions selling, servicing, or promoting them. Satisfaction models have shown the effects on loyalty of concepts like brand reputation, corporate image, trust, and customer service and complaint handling systems [61]. Johnson et al. [15] suggest that pre-purchase expectations are heavily influenced by corporate imagemage, trust, and customer service and complaint handling systems [61]. and institutional trust, making it unnecessary to consider these expectations explicitly as aal. [15] suggest that pre-purchase expectations are heavily influenced by corfactor contributing to satisfaction after the first purchase.e and institutional trust, making it unnecessary to conside

Loyalty might not be relevant to some agricultural innovations (e.g., practices thatctor contributing to satisfaction after the first purchase. are not purchased, such as decisions about the timing of an action), and loyalty could alsoy might not be relevant to some agricultural innovations (e.g., practices that be less likely to be relevant for costly commercial investments relative to much smallerhased, such as decisions about the timing of an action), and loyalty could also personal choices (especially if image-related). Loyalty is also affected by the level of attach-ly to be relevant for costly commercial investments relative to much smaller ment to an existing technology or practice (and the institutions behind them). Satisfactionoices (especially if image-related). Loyalty is also affected by the level of atmodels have borrowed from institutional theory the concept of relationship commitment an existing technology or practice (and the institutions behind them). Satisto represent this attachment. This perceived commitment acts as a psychological barrierels have borrowed from institutional theory the concept of relationship comagainst the rational processes to develop loyalty to an innovation-seeking to replace therepresent this attachment. This perceived commitment acts as a psychological existing way of doing things [15].nst the rational processes to deve

Satisfaction models use three measures of commitment, Affective, normative, andg way of doing things [15]. continuance, to represent the relationships between users and an existing idea, technology,ction models use three measures of commitment, Affective, normative, and conpractice, or institution [66,67]. Commitment concepts can be linked to TPB as follows: represent the relationships between users and an existing idea, technology, Affective commitment (i.e., emotional attachment) can be associated with attitudes, while normative commitment (i.e., sense of moral obligation) can be associated with subjectivemitment (i.e., emotional attachment) can be associated with attitudes, while nornorms, and continuance commitment (i.e., switching costs, feeling of being locked inmitment (i.e., sense of moral obligation) can be associated with subjective norms, or trapped) with perceived control [66]. A recent meta-analysis on the commitment toance commitment (i.e., switching costs, feeling of being locked in or trapped) organizational theory found evidence of cross-cultural validity of commitment measuresved control [66]. A recent meta-analysis on the commitment to organizational across 54 countries [68], opening the possibility of adapting them to agriculture. Figure 10 shows some variables affecting the three components of commitment, based on Meyer and Allen [16].

![](images/99c2d26ca721b4f70d94c28dac06602a5be2224ec8a8057afb1e5343116ca481.jpg)  
Figure 10. Variables affecting commitment to an existing practice or technology. Based on Meyer Figure 10. Variables affecting commitment to an existing practice or technology. Based on Meyer and Allen [16].

# 5. Discussion

In this study, we have identified important elements that adoption researchers and modelers can consider when conducting empirical studies. Firstly, we have highlighted the choice of perspectives that modelers can make, distinguishing between adoption and diffusion modeling perspectives [25]. This is a simple but important distinction because adoption models might consider the drivers that influence decision-making at the individual level and then aggregate up, while numerical diffusion models would normally consider the same drivers but making assumptions about their collective effects on a population as a whole.

This review highlighted that models could provide adoption researchers a structured way to think about the process of adoption and to investigate the impacts of different factors in the adoption process, but it also highlighted the diversity of perspectives on the study of adoption and their implications for modeling. This diversity stems from early conceptual models defined by different disciplines using different theories. Over time, we highlighted how these models have often been combined and adapted for agriculture, resulting in a multitude of interpretations of the elements and interactions that should be included in these models.

Considering this diversity in perspectives, this review found four key elements that adoption researchers and modelers should consider in adoption models for agriculture include: (1) a way to assess the performance of the proposed new technology (e.g., relative advantage, both economic and non-economic) in relation to the existing technology or practice in place, (2) the process of learning about this advantage, (3) the interaction between individual decision-making and external influences, and (4) characteristics of potential adopters affecting their attitudes towards the technology.

Regarding the first key finding, we identified the need to understand the potential benefits of innovation in relation to the existing technology or practice that would be replaced. The review of technology-focused models was a good reminder that in agriculture, it is highly likely that there is already a technology or practice in use delivering benefits to the landowner. Therefore, any new technology will be a replacement for the existing one, emphasizing the need to understand better the current technology in order to make a more accurate measure of the relative advantage of an alternative [1].

We identified models that consider potential benefits explicitly and models in which potential benefits are only implied. The ADOPT model includes a comprehensive exploration of relative advantage (profit, environmental and risk advantages, ease and convenience, etc.), while task-technology fitness models also explicitly link an existing task with a potential technology as a precursor of adoption. On the other hand, in the TPB model, beliefs are informed by the “rational” evaluation of outcomes of different options, implying relative advantage. In Lindner’s model, the trigger for seeking information about an innovation is caused by a change in farming circumstances, implying a mismatch with the existing technology or practice.

The second key finding for adoption researchers and modelers to consider was the role of learning about the relevance of the new technology to the farm. We highlighted how most adoption conceptual models in agriculture define adoption as an information-driven staged process, where transitions from one stage to the next in the process depend on the accumulation of information and the speed to process it (i.e., learning). Examples of models in this review including learning are the ADOPT model, where the role of farmer networks and skills, practice awareness, and practice trialability as important elements influencing the ability of farmers to learn about the relative advantage of technology. Another example is Abadi Ghadim and Pannell’s [13] model, where skill development and experience play an important role in making decisions about innovation.

The third key finding relates to the interaction between individual decision-making and external influences, which also featured as an important element in models included in the review. It is worth noting the big difference amongst models is the way in which external influence is considered. In the ADOPT model, the external influence was partially captured by including the role of group participation and advisers in learning about the innovation. However, these elements are more prevalent in models influenced by the Theory of Planned Behaviour, such as the technology acceptance models and the satisfaction models included in the review, where variables such as social pressure take a prominent role.

The final key element found in the review is the inclusion of characteristics of potential adopters that could affect their attitudes towards technology. A clear example of the interaction between adopters and technology can be seen in the ADOPT model, in which relative advantage is represented as a function that matches farmers’ orientations and the perceived advantages of the innovation. Task-technology fitness models also interact with adopter’s preferences to calculate fitness as a precursor of adoption. On the other hand, satisfaction models suggest a clear separation between the relationship between adopter and technology when assessing the performance of an innovation before and after adoption, to the point that some authors propose that the expectations on innovation performance before are used play virtually no role on the perceived quality and value of the innovation once it is adopted.

We consider that future empirical studies in agricultural adoption could benefit if adoption researchers and modelers take into account these four key findings. However, we also recognize that this review only partially achieved the assessment of the suitability of variables included in the reviewed conceptual models to be used in empirical models. This review identified that virtually all models used to understand adoption in agriculture use concepts that are difficult to observe and quantify, resulting in numerical models that would inevitably reflect the subjective nature of the variables used [69]. This potentially explains some of the divergences in results observed in the literature. Inconsistencies in how different elements are treated in different conceptual models were particularly apparent in behavioral elements such as attitudes, motivations, intentions, and external influences, but they were not covered in detail in this review. For example, motivations (i.e., orientations and preferences) can be included in models capturing individual decisionmaking (e.g., TPB—normative beliefs), or capturing the preferences of groups of people (e.g., ADOPT—population’s orientations), or combined in aggregated behavioral indexes (e.g., Bass model’s coefficients of innovation and imitation).

Finally, we identified four potential areas for further research. Firstly, future research could include questioning whether the adoption of all technologies and practices can be represented by the same adoption or learning process. We pointed out how early studies of adoption were, in many cases, based on the assumption of first purchase or using discrete technologies (e.g., new crops, tractors, fertilizer) mainly to increase profit. We believe that as the complexity and diversity of technologies and practices increase, there is a need to question the adequacy of a “one fits all” process of adoption. Do all technologies follow the same process of adoption? Do they need to be learned the same way?

Secondly, we believe there is an opportunity to further research the proposition by Johnson et al. [15] to study the dynamics in the relationship between adopters and a technology before and after adoption (e.g., attachment, loyalty, etc.). We found that many conceptual models seem to use a ‘transactional’ viewpoint (i.e., the evaluation of relative advantage before adoption as a one-off exercise). Johnson et al. propose considering a ‘relational’ viewpoint. In agriculture, this could be useful in researching the role of trialing in building this relationship, not only between farmers and the innovation, but also with the companies or institutions selling, servicing, or promoting them, which seem important external influences for some innovations. Satisfaction concepts could also be used to better understand the nuances of full, partial, alternating, and opportunistic adoption [8].

Our third suggestion for a potential topic for further research is to question the basic assumptions behind the process of individual decision-making models. In the reviewed conceptual models, we found that external influence is often regarded as a subjective norm (i.e., social pressure) but implying that the final decision about adoption remains an individual one. Future research could investigate further this assumption. For example, there is an ongoing debate in the modeling literature looking at substituting ‘Homo economicus’ in models of decision-making by a ‘Homo socialis’ alternative (see [70]), but those have not been fully explored in agricultural adoption.

The final potential area of research is to conduct a detailed assessment of the discrepancies that exist in defining and measuring the different variables presented in the different conceptual models and how they have been interpreted and used in subsequent empirical studies.

# 6. Conclusions

The objective of this review was to clarify the concepts and approaches used in the practice of modeling the adoption of innovations in agriculture to improve empirical research. We identified four key recommendations that adoption researchers and modelers could consider in their future research while defining models of adoption. We also identified some of the pitfalls that should be avoided while modeling adoption and potential areas for further research.

This review did not present new concepts but structured existing knowledge to illustrate its diversity and the multifaceted contribution that each approach brings to understand the complexity of adoption. This review also illustrates the need to balance this diversity in meaningful syntheses that can assist future research by offering clear direction on how to consider existing knowledge in a holistic manner. We also recognize the need for considering the differences in the types of modern technologies and question some fundamental assumptions still prevalent in empirical studies, such as the “one fits all” process of adoption, the transactional model, and the individual, rational decisionmaking model.

Author Contributions: All authors conceived the presented idea. O.M.d.O.M. wrote the initial manuscript with support from D.J.P. and R.L. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Montes de Oca Munguia, O.; Llewellyn, R. The Adopters versus the Technology: Which Matters More when Predicting or Explaining Adoption? Appl. Econ. Perspect. Policy 2020, 42, 80–91. [CrossRef]   
2. Tey, Y.S.; Brindal, M. Factors influencing the adoption of precision agricultural technologies: A review for policy implications. Precis. Agric. 2012, 13, 713–730. [CrossRef]   
3. Wauters, E.; Mathijs, E. The adoption of farm level soil conservation practices in developed countries: A meta-analytic review. Int. J. Agric. Resour. Gov. Ecol. 2014, 10, 78. [CrossRef]   
4. Liu, T.; Bruins, R.J.F.; Heberling, M.T. Factors Influencing Farmers’ Adoption of Best Management Practices: A Review and Synthesis. Sustainability 2018, 10, 432. [CrossRef] [PubMed]   
5. Douthwaite, B.; Hoffecker, E. Towards a complexity-aware theory of change for participatory research programs working within agricultural innovation systems. Agric. Syst. 2017, 155, 88–102. [CrossRef]   
6. Knowler, D.; Bradshaw, B. Farmers’ adoption of conservation agriculture: A review and synthesis of recent research. Food Policy 2007, 32, 25–48. [CrossRef]   
7. Prokopy, L.S.; Floress, K.; Klotthor-Weinkauf, D.; Baumgart-Getz, A. Determinants of agricultural best management practice adoption: Evidence from the literature. J. Soil Water Conserv. 2008, 63, 300–311. [CrossRef]   
8. Pannell, D.J.; Claassen, R. The Roles of Adoption and Behavior Change in Agricultural Policy. Appl. Econ. Perspect. Policy 2020, 42, 31–41. [CrossRef]   
9. Parker, P.M. Aggregate diffusion forecasting models in marketing: A critical review. Int. J. Forecast. 1994, 10, 353–380. [CrossRef]   
10. Lindner, R.K.; Pardey, P.G.; Jarrett, F.G. Distance to information source and the time lag to early adoption of trace element fertilisers. Aust. J. Agric. Econ. 1982, 26, 98–113. [CrossRef]   
11. Ajzen, I. The theory of planned behavior. Organ. Behav. Hum. Decis. Process. 1991, 50, 179–211. [CrossRef]   
12. Zeweld, W.; Van Huylenbroeck, G.; Tesfay, G.; Speelman, S. Smallholder farmers’ behavioural intentions towards sustainable agricultural practices. J. Environ. Manag. 2017, 187, 71–81. [CrossRef] [PubMed]   
13. Abadi Ghadim, A.; Pannell, D.J. A conceptual framework of adoption of an agricultural innovation. Agric. Econ. 1999, 21, 145–154. [CrossRef]   
14. Kuehne, G.; Llewellyn, R.; Pannell, D.J.; Wilkinson, R.; Dolling, P.; Ouzman, J.; Ewing, M. Predicting farmer uptake of new agricultural practices: A tool for research, extension and policy. Agric. Syst. 2017, 156, 115–125. [CrossRef]   
15. Johnson, M.D.; Gustafsson, A.; Andreassen, T.W.; Lervik, L.; Cha, J. The evolution and future of national customer satisfaction index models. J. Econ. Psychol. 2001, 22, 217–245. [CrossRef]   
16. Meyer, J.P.; Allen, N.J. A three-component conceptualization of organizational commitment. Hum. Resour. Manag. Rev. 1991, 1, 61–89. [CrossRef]   
17. Goodhue, D.L.; Thompson, R.L. Task-Technology Fit and Individual Performance. MIS Q. 1995, 19, 213. [CrossRef]   
18. Venkatesh, V.; Morris, M.G.; Davis, G.B.; Davis, F.D. User acceptance of information technology: Toward a unified view. MIS Q. 2003, 27, 425–478. [CrossRef]   
19. Ryan, B.; Gross, N.C. The diffusion of hybrid seed corn in two Iowa communities. Rural Sociol. 1943. Available online: https://doi.org/citeulike-article-id:1288385 (accessed on 10 November 2020).   
20. Griliches, Z. Hybrid Corn: An Exploration in the Economics of Technological Change. Econometrica 1957, 25, 501. [CrossRef]   
21. Rogers, E.M. Diffusion of Innovations; The Free Press: New York, NY, USA, 1962.   
22. Bass, F.M. A New Product Growth for Model Consumer Durables. Manag. Sci. 1969, 15, 215–227. [CrossRef]   
23. Sneddon, J.; Soutar, G.N.; Mazzarol, T. Modelling the faddish, fashionable and efficient diffusion of agricultural technologies: A case study of the diffusion of wool testing technology in Australia. Technol. Forecast. Soc. Chang. 2011, 78, 468–480. [CrossRef]   
24. Young, H.P. Innovation Diffusion in Heterogeneous Populations: Contagion, Social Influence, and Social Learning. Am. Econ. Rev. 2009, 99, 1899–1924. [CrossRef]   
25. Goss, K.F. Consequences of diffusion of innovations. In Rural Sociology; The Rural Sociological Society: Madison, WI, USA, 1979; Volume 44, pp. 754–772.   
26. Dekimpe, M.G.; Parker, P.M.; Sarvary, M. Global Diffusion of Technological Innovations: A Coupled-Hazard Approach. J. Mark. Res. 2000, 37, 47–59. [CrossRef]   
27. Prochaska, J.M.; Prochaska, J.O.; Levesque, D.A. A Transtheoretical Approach to Changing Organizations. Adm. Policy Ment. Heal. Ment. Heal. Serv. Res. 2001, 28, 247–261. [CrossRef]   
28. Rogers, E.M. Diffusion of Innovations, 5th ed.; The Free Press: New York, NY, USA, 2003.   
29. Adrian, A.M. Factors Influencing Adoption and Use of Precision Agriculture; Auburn University: Auburn, AL, USA, 2006; Available online: https://libproxy.library.unt.edu/login?url=http://proquest.umi.com/pqdweb?did $\underline { { \underline { { \mathbf { \Pi } } } } }$ 1184161591&Fmt=7&clientId=87 &RQT $\mathbf { \bar { \Psi } } = \mathbf { \bar { \Psi } }$ 309&VName=PQD (accessed on 10 November 2020).   
30. Pannell, D.J.; Marshall, G.R.; Barr, N.; Curtis, A.; Vanclay, F.; Wilkinson, R. Understanding and promoting adoption of conservation practices by rural landholders. Aust. J. Exp. Agric. 2006, 46, 1407–1424. [CrossRef]   
31. Sinha, R.K.; Chandrashekaran, M. A Split Hazard Model for Analyzing the Diffusion of Innovations. J. Mark. Res. 1992, 29, 116. [CrossRef]   
32. Dekimpe, M.G.; Parker, P.M.; Sarvary, M. Globalization. Technol. Forecast. Soc. Chang. 2000, 63, 25–42. [CrossRef]   
33. Kauffman, R.J.; Techatassanasoontom, A. International diffusion of digital mobile technology: A coupled hazard approach. Inform. Technol. Manag. 2005, 6, 253–292. [CrossRef]   
34. Khanna, M. Sequential adoption of site-specific technologies and its implications for nitrogen productivity: A double selectivity model. Am. J. Agric. Econ. 2001, 83, 35–51. [CrossRef]   
35. Mwangi, B.; Macharia, I.; Bett, E. A multi-dimensional adoption approach for improved sorghum varieties in eastern Kenya: A climate change adaptation perspective. Clim. Dev. 2020, 1–10. [CrossRef]   
36. Tversky, A.; Kahneman, D. The framing of decisions and the psychology of choice. Science 1981, 211, 453–458. [CrossRef] [PubMed]   
37. Laibson, D.; Zeckhauser, R. Amos Tversky and the Ascent of Behavioral Economics. J. Risk Uncertain. 1998, 16, 7–47. [CrossRef]   
38. Huang, I.B.; Keisler, J.M.; Linkov, I. Multi-criteria decision analysis in environmental sciences: Ten years of applications and trends. Sci. Total Environ. 2011, 409, 3578–3594. [CrossRef] [PubMed]   
39. Behzadian, M.; Kazemzadeh, R.B.; Albadvi, A.; Aghdasi, M. PROMETHEE: A comprehensive literature review on methodologies and applications. Eur. J. Oper. Res. 2010, 200, 198–215. [CrossRef]   
40. Nicholson, C.; Long, J.; England, D.; Long, B.; Creelman, Z.; Mudge, B.; Cornish, D. Farm Decision Making: The Interaction of Personality, Farm Business and Risk to Make More Informed Decisions. Available online: www.grdc.com.au/bookshop (accessed on 29 October 2020).   
41. Daberkow, S.G.; McBride, W.D. Farm and Operator Characteristics Affecting the Awareness and Adoption of Precision Agriculture Technologies in the US. Precis. Agric. 2003, 4, 163–177. [CrossRef]   
42. Abadi Ghadim, A.; Pannell, D.J.; Burton, M.P. Risk, uncertainty, and learning in adoption of a crop innovation. Agric. Econ. 2005, 33, 1–9. [CrossRef]   
43. Barr, N. I hope you are feeling uncomfortable now: Role conflict and the natural resources extension officer. In Changing Land Management Adoption of New Practices by Rural Landholders; Pannell, D., Vanclay, F., Eds.; CSIRO Publishing: Clayton, Australia, 2011; pp. 159–239.   
44. Venkatesh, V.; Thong, J.Y.L.; Xu, X. Unified theory of acceptance and use of technology: A synthesis and the road ahead. J. Assoc. Inform. Syst. 2016, 17, 328–376. [CrossRef]   
45. Rehman, T.; McKemey, K.; Yates, C.; Cooke, R.; Garforth, C.; Tranter, R.; Park, J.; Dorward, P. Identifying and understanding factors influencing the uptake of new technologies on dairy farms in SW England using the theory of reasoned action. Agric. Syst. 2007, 94, 281–293. [CrossRef]   
46. Terry, D.J.; Hogg, M.A.; White, K.M. The theory of planned behaviour: Self-identity, social identity and group norms. J. Soc. Psychol. 1999, 38, 225–244. [CrossRef]   
47. Howden, P.; Vanclay, F. Mythologization of Farming Styles in Australian Broadacre Cropping. Rural. Sociol. 2009, 65, 295–310. [CrossRef]   
48. Vanclay, F.; Howden, P.; Mesiti, L.; Glyde, S. The Social and Intellectual Construction of Farming Styles: Testing Dutch Ideas in Australian Agriculture. Sociol. Rural. 2006, 46, 61–82. [CrossRef]   
49. Sautter, J.A.; Czap, N.V.; Kruse, C.; Lynne, G.D. Farmers’ Decisions Regarding Carbon Sequestration: A Metaeconomic View. Soc. Nat. Resour. 2011, 24, 133–147. [CrossRef]   
50. Price, J.C.; Leviston, Z. Predicting pro-environmental agricultural practices: The social, psychological and contextual influences on land management. J. Rural. Stud. 2014, 34, 65–78. [CrossRef]   
51. Small, B.; Brown, P.; Montes de Oca Munguia, O. Values, trust, and management in New Zealand agriculture. Int. J. Agric. Sustain. 2016, 14, 282–306. [CrossRef]   
52. Niles, M.T.; Brown, M.; Dynes, R. Farmer’s intended and actual adoption of climate change mitigation and adaptation strategies. Clim. Chang. 2015, 135, 277–295. [CrossRef]   
53. Lynne, G.D.; Casey, C.F.; Hodges, A.; Rahmani, M. Conservation technology adoption decisions and the theory of planned behavior. J. Econ. Psychol. 1995, 16, 581–598. [CrossRef]   
54. Arbuckle, J.G. Farmer Attitudes toward Proactive Targeting of Agricultural Conservation Programs. Soc. Nat. Resour. 2012, 26, 625–641. [CrossRef]   
55. Lucas, K.; Brooks, M.; Darnton, A.; Jones, J.E. Promoting pro-environmental behaviour: Existing evidence and policy implications. Environ. Sci. Policy 2008, 11, 456–466. [CrossRef]   
56. Flett, R.; Alpass, F.M.; Humphries, S.; Massey, C.; Morriss, S.; Long, N. The technology acceptance model and use of technology in New Zealand dairy farming. Agric. Syst. 2004, 80, 199–211. [CrossRef]   
57. Feola, G.; Binder, C.R. Towards an improved understanding of farmers’ behaviour: The integrative agent-centred (IAC) framework. Ecol. Econ. 2010, 69, 2323–2333. [CrossRef]   
58. Aubert, B.A.; Schroeder, A.; Grimaudo, J. IT as enabler of sustainable farming: An empirical analysis of farmers’ adoption decision of precision agriculture technology. Decis. Support Syst. 2012, 54, 510–520. [CrossRef]   
59. Pérez-Escudero, A.; de Polaviejay, G.G. The informative herd: Why humans and other animals imitate more when conditions are adverse. arXiv 2014, arXiv:1403.7478.   
60. Cabral, R. QoE: Quality of experience. A conceptual essay. In Integration and Innovation Orient to E-Society; Wang, W., Ed.; IFIP International Federation for Information Processing: Amsterdam, The Netherlands; Springer: Berlin/Heidelberg, Germany, 2007; Volume 252, pp. 193–199.   
61. Fornell, C.; Johnson, M.D.; Anderson, E.W.; Bryant, B.E. The American customer satisfaction index: Nature, purpose, and findings. J. Mark. 1996, 60, 7–18. [CrossRef]   
62. Van Ittersum, K.; Feinberg, F. Cumulative Timed Intent: A New Predictive Tool for Technology Adoption. J. Mark. Res. 2010, 47, 808–822. [CrossRef]   
63. Deming, W.E. Management of Statistical Techniques for Quality and Productivity; New York University: New York, NY, USA, 1981.   
64. Juran, J.M.; Gryna, F.M. Juran’s Quality Control Handbook, 4th ed.; McGraw-Hill: New York, NY, USA, 1988.   
65. Bloemer, J.; Kasper, H.D. The complex relationship between consumer satisfaction and brand loyalty. J. Econ. Psychol. 1995, 16, 311–329. [CrossRef]   
66. Allen, N.J.; Meyer, J.P. The measurement and antecedents of affective, continuance and normative commitment to the organization. J. Occup. Psychol. 1990, 63, 1–18. [CrossRef]   
67. Garbarino, E.; Johnson, M. The different roles of satisfaction, trust, and commitment in customer relationships. J. Mark. 1999, 63, 70–87. [CrossRef]   
68. Meyer, J.P.; Stanley, D.W.; Jackson, T.A.; McInnis, K.J.; Maltin, E.R.; Sheppard, L. Affective, normative, and continuance commitment levels across cultures: A meta-analysis. J. Vocat. Behav. 2012, 80, 225–245. [CrossRef]   
69. Mathis, K.; Steffen, A.D. European perspectives on behavioural law and economics. In Economic Analysis of Law in European Legal Scholarship; Mathis, K., Ed.; Springer: Cham, Switzerland, 2015; pp. 1–271. [CrossRef]   
70. Gintis, H. Modeling Homo Socialis: A Reply to Critics. Rev. Behav. Econ. 2015, 2, 211–237. [CrossRef]